# Topology Identification and Learning over Graphs: Accounting for Nonlinearities and Dynamics

识别图的拓扑结构以及在图上演化的过程出现在涉及基因调控，大脑，力量和社交网络的各种应用中，仅举几例。关键的图感知学习任务包括回归，分类，子空间聚类，异常识别，内插，外推和降维。处理此类高维任务的可扩展方法经历了范式转换，以解决与数据驱动科学相关的独特建模和计算难题。尽管简单且易于处理，但线性时不变模型受到限制，因为它们无法处理一般发展的拓扑，以及节点过程之间的非线性和动态依存关系。为此，本文的主要目的是概述总体进展，并开发一种原理性框架以通过内核捕获非线性，该内核是从预选字典中明智地选择出来的，以最佳地拟合数据。该框架包含和利用（非线性）部分相关性和部分Granger因果关系的线性对应物，以及（非线性）线性结构方程和矢量自回归，以及诸如低秩，稀疏性和平滑度之类的属性，以捕获甚至突然的方向性依存关系。更改点以及可能随时间变化的拓扑上随时间变化的过程。总体方法继承了基于内核的方法的通用性和通用性，并使其适用于批处理和计算上可以承受的在线学习算法，其中包括新颖的图式卡尔曼滤波器。实际数据实验凸显了非线性和动态模型对消费者和金融网络以及基因调控和功能连通性大脑网络的影响，其中连通性模式揭示出与现有方法相比具有明显的差异。

Identifying graph topologies as well as processes evolving over graphs emerge in various applications involving gene-regulatory, brain, power, and social networks, to name a few. Key graph-aware learning tasks include regression, classification, subspace clustering, anomaly identification, interpolation, extrapolation, and dimensionality reduction. Scalable approaches to deal with such high-dimensional tasks experience a paradigm shift to address the unique modeling and computational challenges associated with data-driven sciences. Albeit simple and tractable, linear time-invariant models are limited since they are incapable of handling generally evolving topologies, as well as nonlinear and dynamic dependencies between nodal processes. To this end, the main goal of this paper is to outline overarching advances, and develop a principled framework to capture nonlinearities through kernels, which are judiciously chosen from a preselected dictionary to optimally fit the data. The framework encompasses and leverages (non) linear counterparts of partial correlation and partial Granger causality, as well as (non)linear structural equations and vector autoregressions, along with attributes such as low rank, sparsity, and smoothness to capture even directional dependencies with abrupt change points, as well as time-evolving processes over possibly time-evolving topologies. The overarching approach inherits the versatility and generality of kernel-based methods, and lends itself to batch and computationally affordable online learning algorithms, which include novel Kalman filters over graphs. Real data experiments highlight the impact of the nonlinear and dynamic models on consumer and financial networks, as well as gene-regulatory and functional connectivity brain networks, where connectivity patterns revealed exhibit discernible differences relative to existing approaches.